﻿<%@ Page Title="" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="SRS.aspx.cs" Inherits="TBI_Instruments_SRS" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>


<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>
        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>
        <script type="text/javascript">
            $(document).ready(function() {
                $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function() {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                    // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Supervision Rating Scale"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="SRS" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                        <h2>
                            GENERAL INSTRUCTIONS</h2>
                        Please demonstrate each task and/or give instructions as written. When scoring, please record the lowest response category
                        that applies for each item.
                        <p>
                            Below each item, select the number that best describes the level at which the person being evaluated experiences problems. Mark the
                            greatest level of problem that is appropriate. Problems that interfere rarely with daily or valued activities, that is, less than 5% of the time,
                            should be considered not to interfere. Write comments about specific items at the end of the rating scale.</p>
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                
                <br />
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->                    
                    <table style="width:800px; margin-left:20px;">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Q1
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="23">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ1" TabIndex="24"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1" TabIndex="25" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>

                    </table>
                    
        
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                
                <table style="width:800px; margin-left:20px;">
                    <tr>
                        <td style="width: 20px;">
                            &nbsp;
                        </td>
                        <td>
                            <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                            </telerik:RadAjaxPanel>
                            <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                                ValidationGroup="OnSaveDraft" TabIndex="101" />
                            <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                                ValidationGroup="OnSave" TabIndex="102" />
                            <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="103" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                        <td>
                            <i>Corwin Boake, Ph.D., TIRR, 1333 Moursund, Houston, TX 77030-3405, 713/799-6990</i>
                        </td>
                    </tr>
                </table>
                
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
